 
   /**********************************************************************\
   *                                                                      *
   * Author:   Paul Lapsansky                                             *
   * Date:     04/16/96                                                   *
   *                                                                      *
   * File:     demo.c                                                     *
   *                                                                      *
   * Descrpt:  Demonstrates functions found in the SYSTEM INFO LIBRARY.   *
   *                                                                      *
   * Language: Borland C++                                                *
   *                                                                      *
   * Platform: MS-DOS                                                     *
   *                                                                      *
   \**********************************************************************/
 
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <alloc.h>
#include <dos.h>
#include "sysinfo.h"

#define TOP    127                       // bright white on white
#define BOT    120                       // gray on white
#define TITLE  112                       // black on white
#define LABELS 30                        // yellow on blue
#define INFO   31                        // bright white on blue
#define CHECK  28                        // bright red on blue
#define CLEAR  7                         // white on black

void main(void)
{
   int i;                                // counter    
   int x,y;                              // x and y coordinates
   int num;                              // logical drive number
   int code;                             // ascii code
   int model,submodel,rev;               // model information
   int bus;                              // system bus type
   int cpu,npu;                          // processor information
   int DMA3,s8259,realtime,keyint,       // feature byte information
       event,extbios,MCA;
   int addr;                             // I/O port address
   int uart;                             // UART type
   long ext,exta;                        // extended memory
   int ems,emsa;                         // EMS memory
   long xmsa,xmsb;                       // XMS memory
   int vram;                             // video card memory
   int major,minor,drvMaj,drvMin;        // version information              
   int A20,HMA;                          // XMS information
   int handles,segment;                  // EMS information
   int emm;                              // '386 EMM type
   int card;                             // video card type
   int buttons,type,irq;                 // mouse information
   int oem;                              // DOS OEM number
   int drdos;                            // DR-DOS version
   int mode;                             // Windows or CPU mode
   int dblspace,stacker,mscdex;          // installed flags
   int a,b;                              // floppy drive type
   int lastdrive;                        // available drives
   int removable,remote;                 // drive type
   int heads,cyl,sectors;                // hard-drive information
   int version,sub,conn,use,vol,peak;    // NetWare File Server Information
   int year,month,day,hour,min,sec,week; // login date and time

   long SecPerClus,FreeClus,BytesPerSec, // misc. drive space information
        TotalClus,ClusSize,FreeSpace,
        TotalSpace;

   char *drive,                          // drive letter
        *pcdate,                         // system BIOS date
        *server,                         // server name
        *user;                           // user name

   _setcursortype(_NOCURSOR);            // turn off cursor

   /**********************************************************************\
   *                          Initialization...                          *
   \**********************************************************************/ 

   clrscr();                  
   textattr(TOP); cputs("");
   textattr(BOT); cputs(" ");
   textattr(TOP); cputs("");
   textattr(TITLE); cputs(" Version 1.3         ");
   textattr(BOT); cputs(" ");
   textattr(TITLE); cputs("     SYSTEM INFO LIBRARY DEMO                BC Edition ");
   textattr(BOT); cputs("");
   textattr(TOP); cputs("");
   textattr(TITLE); cputs("                    Copyright(c) 1994-96 By Paul Lapsansky                    ");
   textattr(BOT); cputs(" ");
   textattr(LABELS); cputs("                                                                                                                                 ");
   cputs("                                                                                                                                               ");
   cputs("                                                                                                                                               ");
   cputs("                                                                                                                                               ");
   cputs("                                                                                                                                               ");
   cputs("                                                                                                                                               ");
   cputs("                                                                                                                                               ");
   cputs("                                                                                                                                               ");
   cputs("                                                                                                                                               ");
   cputs("                                                                                       ");
   textattr(TOP); cputs("");
   textattr(TITLE); cputs(" ");
   textattr(TOP); cputs("");
   textattr(TITLE); cputs("                        Press any key for next screen...                      ");
   textattr(BOT); cputs(" ");
   window(1,5,80,21);

   /**********************************************************************\
   *                 Display Hardware Information Screen                  *
   \**********************************************************************/ 

   textattr(LABELS);     
   gotoxy(37,2);cputs("Computer");
   gotoxy(4,4);cputs("BIOS Category     :");
   gotoxy(4,5);cputs("BIOS I.D.         :");
   gotoxy(4,6);cputs("BIOS Date         :");
   gotoxy(4,7);cputs("Bus Type          :");
   gotoxy(4,9);cputs("Processor         :");
   gotoxy(4,10);cputs("Math Co-processor :");
   gotoxy(4,11);cputs("Processor Speed   :");
   gotoxy(4,12);cputs("Processor Mode    :");
   gotoxy(4,14);cputs("Keyboard Type     :");
   gotoxy(43,7);cputs("DMA Channel 3 used            :");
   gotoxy(43,8);cputs("2nd 8259 installed            :");
   gotoxy(43,9);cputs("Real Time Clock installed     :");
   gotoxy(43,10);cputs("Keyboard Int. (INT 15/AH=4F)  :");
   gotoxy(43,11);cputs("Wait for External Event       :");
   gotoxy(43,12);cputs("Extended BIOS allocated       :");

   textattr(INFO);                         

   getID(&model,&submodel,&rev);         // get model information
   pcdate=biosDate();                    // get BIOS date

   gotoxy(24,4);
   switch (model) {                      // display model type
    case 0xFF:
      switch (submodel) {
        case 0x46:
          cputs("Olivetti M15");
          break;
        default:
          if(!strcmp(pcdate,"04/24/81")) 
            cputs("IBM PC");
          else if(!strcmp(pcdate,"10/19/81")) 
            cputs("IBM PC");
          else if(!strcmp(pcdate,"10/27/82")) 
            cputs("IBM PC");
          else if (peekb(0xF000,0xC000)==0x21)   // check for TANDY 1000 
            cputs("TANDY 1000");
           else
            cputs("IBM PC compatible");
            break;
      }
      break;
    case 0xFE:
      switch (submodel) {
        case 0x43:
          cputs("Olivetti M240");
          break;
        case 0xA6:
          cputs("Quadram Quad386");
          break;
        default:
          if(!strcmp(pcdate,"08/16/82"))
            cputs("IBM PC/XT");
          else if(!strcmp(pcdate,"11/08/82"))
            cputs("IBM PC/XT");
          else
            cputs("IBM PC/XT compatible");
      }
      break;
    case 0xFD:
      cputs("IBM PCjr");
      break;
    case 0xFC:
      switch (submodel) {
        case 0x01:
          switch (rev) {
            case 0x20:
              cputs("AST");
              break;
            case 0x30:
              cputs("Tandy 3000NL");
              break;
            default:
              if(!strcmp(pcdate,"11/15/85"))
                cputs("IBM AT Model 3x9");
              else if(!strcmp(pcdate,"09/17/87"))
                cputs("Tandy 3000");
              else if(!strcmp(pcdate,"03/08/93"))
                cputs("Compaq DESKPRO/i");
              else if(!strcmp(pcdate,"04/12/93"))
                cputs("Compaq");
              else if(!strcmp(pcdate,"07/20/93"))
                cputs("Zenith Z-Lite 425L");
              else
                cputs("IBM AT compatible");
                break;
          }
          break;
        case 0x02:
          if(!strcmp(pcdate,"04/21/86"))
            cputs("IBM XT-286");
          else if(!strcmp(pcdate,"08/05/93"))
            cputs("Compaq Contura 486/486c/486cx");
          else
            cputs("IBM AT compatible");
          break;
        case 0x04:
          switch (rev) {
            case 0x00:
              cputs("PS/2 Model 50");
              break;
            case 0x01:
              cputs("PS/2 Model 50");
              break;
            case 0x02:
              if(!strcmp(pcdate,"01/28/88"))
                cputs("PS/2 Model 50Z");
              else
                cputs("PS/2 Model 50");
              break;
            case 0x03:
              cputs("PS/2 Model 50Z");
              break;
            case 0x04:
              cputs("PS/2 Model 50Z");
              break;
            default:
              cputs("IBM AT compatible");
              break;
          }
          break;
        case 0x05:
          cputs("PS/2 Model 60");
          break;
        case 0x06:
          cputs("IBM 7552-x40 GearBox");
          break;
        case 0x08:
          cputs("PS/2 Model 25-286");
          break;
        case 0x09:
          if(!strcmp(pcdate,"08/25/88"))
            cputs("PS/2 Model 30-286");
          else if(!strcmp(pcdate,"06/28/89"))
            cputs("PS/2 Model 30-286");
          else
            cputs("PS/2 Model 25");
          break;
        case 0x0B:
          cputs("PS/1 Model 2011");
          break;
        case 0x20:
          cputs("Compaq ProLinea");
          break;
        case 0x30:
          cputs("Epson");
          break;
        case 0x31:
          cputs("Epson");
          break;
        case 0x33:
          cputs("Epson");
          break;
        case 0x42:
          cputs("Olivetti M280");
          break;
        case 0x45:
          cputs("Olivetti M380");
          break;
        case 0x48:
          cputs("Olivetti M290");
          break;
        case 0x4F:
          cputs("Olivetti M250");
          break;
        case 0x50:
          cputs("Olivetti M380");
          break;
        case 0x51:
          cputs("Olivetti PCS286");
          break;
        case 0x52:
          cputs("Olivetti M300");
          break;
        case 0x94:
          cputs("Zenith 386");
          break;
        default:
          if(!strcmp(pcdate,"01/10/84"))
            cputs("IBM AT Model 068/099");
          else if(!strcmp(pcdate,"06/10/85"))
            cputs("IBM AT Model 239");
          else
            cputs("IBM AT compatible");
          break;
      }
      break;
    case 0xFB:
      switch (submodel) {
        case 0x4C:
          cputs("Olivetti M200");
          break;
        default:
          if(!strcmp(pcdate,"01/10/86"))
            cputs("IBM PC/XT");
          else if(!strcmp(pcdate,"05/09/86"))
            cputs("IBM PC/XT");
          else
            cputs("IBM PC/XT compatible");
          break;
      }
      break;
    case 0xFA:
      switch (submodel) {
        case 0x00:
          cputs("PS/2 Model 30");
          break;
        case 0x01:
          cputs("PS/2 Model 25/25L");
          break;
        case 0x4E:
          cputs("Olivetti M111");
          break;
        case 0xFE:
          cputs("IBM PCradio 9075");
          break;
        default:
          cputs("Unknown Model!");
          break;
      }
      break;
    case 0xF9:
      cputs("IBM PC Convertible");
      break;
    case 0xF8:
      switch (submodel) {
        case 0x00:
          if(!strcmp(pcdate,"03/30/87"))
            cputs("PS/2 Model 80");
          else
            cputs("PS/2 Model 75-486");
          break;
        case 0x01:
          cputs("PS/2 Model 80");
          break;
        case 0x02:
          cputs("PS/2 Model 55");
          break;
        case 0x04:
          cputs("PS/2 Model 70");
          break;
        case 0x05:
          cputs("IBM PC 7568");
          break;
        case 0x06:
          cputs("PS/2 Model 55");
          break;
        case 0x07:
          if(rev==0x00)
            cputs("IBM PC 7561/2");
          else if(rev==0x01)
            cputs("PS/2 Model 55");
          else if(rev==0x02)
            cputs("IBM PC 7561/2");
          else if(rev==0x03)
            cputs("PS/2 Model 55");
          else
            cputs("Unknown Model!");
          break;
        case 0x09:
          cputs("PS/2 Model 70");
          break;
        case 0x0B:
          cputs("PS/2 Model P70");
          break;
        case 0x0C:
          cputs("PS/2 Model 55SX");
          break;
        case 0x0D:
          cputs("PS/2 Model 70");
          break;
        case 0x0E:
          cputs("PS/1 486SX");
          break;
        case 0x0F:
          cputs("PS/1 486DX");
          break;
        case 0x10:
          cputs("PS/2 Model 55");
          break;
        case 0x11:
          cputs("PS/2 Model 90XP");
          break;
        case 0x12:
          cputs("PS/2 Model 95XP");
          break;
        case 0x13:
          cputs("PS/2 Model 90XP");
          break;
        case 0x14:
          cputs("PS/2 Model 90/95XP");
          break;
        case 0x15:
          cputs("PS/2 Model 90XP");
          break;
        case 0x16:
          cputs("PS/2 Model 90/95XP");
          break;
        case 0x17:
          cputs("PS/2 Model 90XP");
          break;
        case 0x19:
          if(!strcmp(pcdate,"03/15/91"))
            cputs("PS/2 Model 35SX/40SX"); 
          else if(!strcmp(pcdate,"04/04/91"))
            cputs("PS/2 Model 35SX/40SX");
          else
            cputs("PS/2 Model 35/35LS/40");
          break;
        case 0x1A:
          cputs("PS/2 Model 95XP");
          break;
        case 0x1B:
          cputs("PS/2 Model 70-486");
          break;
        case 0x1C:
          cputs("PS/2 Model 65");
          break;
        case 0x1E:
          cputs("PS/2 Model 55LS");
          break;
        case 0x1F:
          cputs("PS/ValuePoint");
          break;
        case 0x23:
          cputs("PS/2 Model L40SX");
          break;
        case 0x25:
          if(rev==0x00)
            cputs("PS/2 Model 57SLC");
          else if(rev==0x06)
            cputs("PS/2 Model M57");
          else
            cputs("PS/2 Model 57SX");
          break;
        case 0x26:
          cputs("PS/2 Model 57SX");
          break;
        case 0x28:
          cputs("PS/2 Model 95XP");
          break;
        case 0x29:
          cputs("PS/2 Model 90XP");
          break;
        case 0x2A:
          cputs("PS/2 Model 95XP");
          break;
        case 0x2B:
          cputs("PS/2 Model 90XP");
          break;
        case 0x2C:
          cputs("PS/2 Model 95");
          break;
        case 0x2D:
          cputs("PS/2 Model 90XP");
          break;
        case 0x2E:
          cputs("PS/2 Model 95XP");
          break;
        case 0x2F:
          cputs("PS/2 Model 90XP");
          break;
        case 0x30:
          cputs("PS/1 Model 2121");
          break;
        case 0x33:
          cputs("PS/2 Model 30-386");
          break;
        case 0x34:
          cputs("PS/2 Model 25-386");
          break;
        case 0x36:
          cputs("PS/2 Model 95XP");
          break;
        case 0x37:
          cputs("PS/2 Model 90XP");
          break;
        case 0x38:
          cputs("PS/2 Model 57");
          break;
        case 0x39:
          cputs("PS/2 Model 95XP");
          break;
        case 0x3F:
          cputs("PS/2 Model 90XP");
          break;
        case 0x40:
          cputs("PS/2 Model 95XP");
          break;
        case 0x41:
          cputs("PS/2 Model 77");
          break;
        case 0x45:
          cputs("PS/2 Model 90XP");
          break;
        case 0x46:
          cputs("PS/2 Model 95XP");
          break;
        case 0x47:
          cputs("PS/2 Model 90/95");
          break;
        case 0x48:
          cputs("PS/2 Model 85");
          break;
        case 0x49:
          cputs("PS/ValuePoint 325T");
          break;
        case 0x4A:
          cputs("PS/ValuePoint 425SX");
          break;
        case 0x4B:
          cputs("PS/ValuePoint 433DX");
          break;
        case 0x4E:
          cputs("PS/2 Model 295");
          break;
        case 0x50:
          cputs("PS/2 Model P70");
          break;
        case 0x52:
          cputs("PS/2 Model P75");
          break;
        case 0x56:
          cputs("PS/2 Model CL57SX");
          break;
        case 0x57:
          cputs("PS/2 Model 90XP");
          break;
        case 0x58:
          cputs("PS/2 Model 95XP");
          break;
        case 0x59:
          cputs("PS/2 Model 90XP");
          break;
        case 0x5A:
          cputs("PS/2 Model 95XP");
          break;
        case 0x5B:
          cputs("PS/2 Model 90XP");
          break;
        case 0x5C:
          cputs("PS/2 Model 95XP");
          break;
        case 0x5D:
          cputs("PS/2 Model N51SLC");
          break;
        case 0x5E:
          cputs("IBM ThinkPad 700");
          break;
        case 0x61:
          cputs("Olivetti P500");
          break;
        case 0x62:
          cputs("Olivetti P800");
          break;
        case 0x80:
          cputs("PS/2 Model 80");
          break;
        case 0x81:
          cputs("PS/2 Model 55");
          break;
        case 0x87:
          cputs("PS/2 Model N33SX");
          break;
        case 0x88:
          cputs("PS/2 Model 55");
          break;
        case 0x97:
          cputs("PS/2 Model 55 Note N23SX");
          break;
        case 0x99:
          cputs("PS/2 Model N51SX");
          break;
        default:
          cputs("PS/2");
          break;
      }
      break;
    case 0xE1:
      cputs("PS/2 Model 55 Laptop");
      break;
    case 0x9A:
      cputs("Compaq XT/Plus");
      break;
    case 0x30:
      cputs("Sperry PC");
      break;
    case 0x2D:
      cputs("Compaq PC/Deskpro");
      break;
    default:
      cputs("Unknown model!");
      break;
   }

   gotoxy(24,5);                       
   cprintf("%02X %02X %02X",model,submodel,rev); // display model I.D.

   gotoxy(24,6);
   cputs(pcdate);                        // display BIOS date
   
   bus = getBusType();                   // get system bus type

   gotoxy(24,7);
   switch (bus) {                        // display bus type
     case 1:
       cputs("ISA");
       break;
     case 2:
       cputs("MCA");
       break;
     case 3:
       cputs("EISA");
   }
    
   cpu=getCPU();                         // get processor type
   npu=getNPU();                         // get math-coprocessor type
  
   gotoxy(24,9);                        
   switch (cpu) {                        // display processor type
     case 1:
       if(getPFQ()==1)
         cputs("NEC V20");
       else
         cputs("NEC V30");
       break;
     case 2:
       if(getPFQ()==1)
         cputs("8088");
       else
         cputs("8086");
       break;
     case 3:
       if(getPFQ()==1)
         cputs("80188");
       else
         cputs("80186");
       break;
     case 4:
       cputs("80286");
       break;
     case 5:
       cputs("80386");
       break;
     case 6:
       if(npu) 
         cputs("80486DX");
       else
         cputs("80486SX");
       break;
     case 7:
       cputs("Pentium");
   }

   gotoxy(24,10);                        
   switch (npu) {                        // display math co-processor type
     case 1:
       cputs("8087");
       break;
     case 2:
       cputs("80287");
       break;
     case 3:
       cputs("80387");
       break;
     case 4:   
       cputs("Internal");
       break; 
     case 5:
       cputs("Internal");
       break;   
     default:
       cputs("Not installed");
   }
   
   gotoxy(24,11);
   cprintf("%dMhz",getMhz());            // get CPU speed

   mode = getCPUmode();                  // get CPU mode

   gotoxy(24,12);
   switch (mode) {                       // display CPU mode
     case 1:
       cputs("Real");                   
       break;
     case 2:
       cputs("Protected");
       break;
     case 3:
       cputs("V86");                     
       break;
     default:
       cputs("Not supported");
   }

   gotoxy(24,14);                    
   if(chkEnhKeyb())                      // get keyboard type
     cputs("Enhanced Keyboard");
   else
     cputs("Standard Keyboard");

                                         // get feature byte information
   if(!getFeatures(&DMA3,&s8259,&realtime,&keyint,&event,&extbios,&MCA)) {
     textattr(CHECK);                       
     gotoxy(75,7);                       
     if(DMA3)                            // display if DMA3 used
       cputs("yes");
     else
       cputs("no");
     gotoxy(75,8);
     if(s8259)                           // display if a slave 8259 available
       cputs("yes");
     else
       cputs("no");
     gotoxy(75,9);                      
     if(realtime)                        // display if a realtime clock is avail
       cputs("yes");
     else
       cputs("no");
     gotoxy(75,10);
     if(keyint)                          // display if keyboard intercept avail
       cputs("yes");
     else
       cputs("no");
     gotoxy(75,11);                     
     if(event)                           // display if external event available
       cputs("yes");
     else
       cputs("no");
     gotoxy(75,12);                     
     if(extbios)                         // display if extended BIOS available
       cputs("yes");
     else
       cputs("no");
   }

   getch();                              // wait for keystroke
   textattr(CLEAR);                          
   clrscr();                             // clear screen
   
   /**********************************************************************\
   *                       Display I/O Ports Screen                       *
   \**********************************************************************/ 

   textattr(LABELS);
   clrscr();    
   gotoxy(37,2);cputs("I/O Ports");
   gotoxy(23,4);cputs("    Label      Address     UART");
   gotoxy(23,5);cputs("");
                       
   textattr(INFO);

   y = 6;
   for(i=1; i<=4; i++) {                 // display COM ports
     addr = getCOMaddr(&i);
     if(addr) {
       gotoxy(23,y);
       cprintf("    COM%d         %Xh",i,addr);
       uart = getUART(&addr);            // get UART type
       switch (uart) {
         case 0:
           cputs("      ----");
           break;
         case 1:
           cputs("      8250");
           break;
         case 2:
           cputs("     16450");
           break;
         case 3:
           cputs("    16C1450");
           break;
         case 4:
           cputs("     16550");
           break;
         case 5:
           cputs("    16550AF");
           break;
         case 6:
           cputs("    16C1550");
           break;
         case 7:
           cputs("     16552");
           break;
         case 8:
           cputs("     82510");
       }
       y++;
     }
   }

   for(i=1; i<=getLPT(); i++) {          // display LPT ports
     addr = getLPTaddr(&i);
     if(addr) {
       gotoxy(23,y);
       cprintf("    LPT%d         %Xh      ----",i,addr);
       y++;
     }
   }

   getch();                              // wait for keystroke
   textattr(CLEAR);                        
   clrscr();                             // clear screen

   /**********************************************************************\
   *                       Display Memory Screen                          *
   \**********************************************************************/ 

   textattr(LABELS);
   clrscr();   
   gotoxy(38,2);cputs("Memory");
   gotoxy(4,4);cputs("Total Conventional Memory :");
   gotoxy(4,5);cputs("Free Conventional Memory  :");
   gotoxy(4,7);cputs("Total Extended Memory     :");
   gotoxy(4,8);cputs("Free Extended Memory      :");
   gotoxy(4,10);cputs("Available XMS Memory      :");
   gotoxy(4,11);cputs("Largest XMS Memory Block  :");
   gotoxy(4,12);cputs("XMS Version               :");
   gotoxy(4,13);cputs("XMS Driver Version        :");
   gotoxy(4,14);cputs("A20 Address Line          :");
   gotoxy(4,15);cputs("High Memory Area          :");
   gotoxy(4,17);cputs("'386 Extended Memory Manager :");
   gotoxy(46,4);cputs("Total EMS Memory    :");
   gotoxy(46,5);cputs("Free EMS Memory     :");
   gotoxy(46,6);cputs("EMS Version         :");
   gotoxy(46,7);cputs("EMS Address Page    :");
   gotoxy(46,8);cputs("Handles in Use      :");
   gotoxy(46,10);cputs("DPMI Installed      :");
   gotoxy(46,11);cputs("DPMI Version        :");
   gotoxy(46,13);cputs("VCPI Installed      :");
   gotoxy(46,14);cputs("VCPI Version        :");

   textattr(INFO);                        

   gotoxy(32,4);                        
   cprintf("%dK",getRAM());              // display total conventional memory

   gotoxy(32,5);                        
   cprintf("%luK",farcoreleft()/1024);   // display free conventional memory

   if(cpu > 3) {                         // check for '286 or higher
     gotoxy(32,7);              
     ext=getExt();                       // get total extended memory
     cprintf("%ldK",ext);                // display total extended memory
     gotoxy(32,8);                  
     exta=getAvailExt();                 // get available extended memory
     cprintf("%ldK",exta);               // display available extended memory
     if(chkXMS()) {                      // check for XMS driver 
       if(!getXMSa(&xmsa,&xmsb)) {       // get XMS memory
         gotoxy(32,10);                     
         cprintf("%ldK",xmsa);           // display available XMS memory
         gotoxy(32,11);
         cprintf("%ldK",xmsb);           // display largest XMS block
       }
   
       if(!getXMSv(&major,&minor,&drvMaj,&drvMin)) {  // get XMS version
         gotoxy(32,12);
         cprintf("%d.%02d",major,minor);   // display XMS version
         gotoxy(32,13);
         cprintf("%d.%02d",drvMaj,drvMin); // display XMS driver version
       }

       if(!getXMSi(&HMA,&A20)) {         // get XMS information
         textattr(CHECK);                  
         gotoxy(32,14);
         if(A20)                         // display if A20 enabled
           cputs("Enabled");
         else
           cputs("Not Enabled");
         gotoxy(32,15);
         if(HMA)                         // display if HMA available
           cputs("Available");
         else
           cputs("Not Available");
         textattr(INFO);                  
       }
     }
   }

   if(chkEMS()) {                        // check for EMS memory
     if(!getEMS(&ems,&emsa)) {           // get EMS memory
       gotoxy(68,4);
       cprintf("%dK",ems*16);            // display total EMS memory
       gotoxy(68,5);
       cprintf("%dK",emsa*16);           // display available EMS memory
     }

     if(!getEMSv(&major,&minor)) {       // get EMS driver version
       gotoxy(68,6);
       cprintf("%d.%02d",major,minor);   // display EMS driver version
     }

     if(!getEMSi(&handles,&segment)) {   // get EMS information
       gotoxy(68,7);
       cprintf("%X",segment);            // display EMS page frame address
       gotoxy(68,8);
       cprintf("%d",handles);            // display handles used
     }
   }
   else {
     gotoxy(68,4);
     cputs("0K");                        // display total EMS memory
     gotoxy(68,5);
     cputs("0K");                        // display available EMS memory
   }

   if(cpu > 3) {                         // check for '286 or higher
     if(chkDPMI()) {                     // check for DPMI driver
       textattr(CHECK);                    
       gotoxy(68,10);
       cputs("yes");
       textattr(INFO);                    
       if(!getDPMIv(&major,&minor)) {    // get DPMI version
         gotoxy(68,11);
         cprintf("%d.%02d",major,minor); // display DPMI version
       }
     }
     else {
       textattr(CHECK);                    
       gotoxy(68,10);
       cputs("no");
       textattr(INFO);                    
     }
   }
   else {
     textattr(CHECK);                    
     gotoxy(68,10);
     cputs("no");
     textattr(INFO);                    
   }

   emm = 0;                           // default to EMM not installed
   if(cpu > 4 && chkXMS()) {          // check for '386 or higher and XMS
     emm=getEMM();                    // get '386 Extended Memory Manager type
     gotoxy(35,17);
     switch (emm) {
       case 1:
         cputs("Quadtel QMAPS or Hewlett-Packard HPMM.SYS");
         break;
       case 2:
         cputs("Microsoft EMM386.EXE");
         break;
       case 3:
         cputs("Microsoft Windows WIN386.EXE");
         break;
       case 4:
         cputs("DR-DOS EMM386.SYS");
         break;
       case 5:
         cputs("Qualitas 386MAX");
         break;
       case 6:
         cputs("V Communication's Memory Commander");
         break;
       case 7:
         cputs("Quarterdeck QEMM-386");
         break;
       case 8:
         cputs("Helix Netroom RM386");
         break;
       case 9:
         cputs("OS/2");
         break;
       default:
         cputs("Unknown or 386 Memory Manager not installed!");
     }
   }
                                         
   if(emm > 0) {                         // check for extended memory manager
     if(chkVCPI()) {                     // check for VCPI driver
       textattr(CHECK);                    
       gotoxy(68,13);
       cputs("yes");
       textattr(INFO);                    
       getVCPIv(&major,&minor);          // get VCPI version
       gotoxy(68,14);
       cprintf("%d.%02d",major,minor);   // display VCPI version
     }
     else {
       textattr(CHECK);                    
       gotoxy(68,13);
       cputs("no");
       textattr(INFO);                    
     }
   }
   else {
     textattr(CHECK);                      
     gotoxy(68,13);
     cputs("no");
     textattr(INFO);                      
   }

   getch();                              // wait for keystroke
   textattr(CLEAR);                        
   clrscr();                             // clear screen

   /**********************************************************************\
   *                   Display Video Information Screen                   *
   \**********************************************************************/ 

   textattr(LABELS);
   clrscr();    
   gotoxy(34,2);cputs("Video and Sound");
   gotoxy(17,6);cputs("Video Adapter Type     :");
   gotoxy(17,7);cputs("Display Type           :");
   gotoxy(17,10);cputs("VESA Support Installed :");
   gotoxy(17,11);cputs("VESA Version           :");
   gotoxy(17,12);cputs("Video Memory           :");

   textattr(INFO);                        

   gotoxy(42,6);

   card=getVideo();                      // get video card type

   switch (card) {
     case 1:
       cputs("MDA - Monochrome Display Adapter");
       break;
     case 2:
       cputs("HGA - Hercules Graphics Adapter");
       break;
     case 3:
       cputs("CGA - Color Graphics Adapter");
       break;
     case 4:
       cputs("EGA - Enhanced Graphics Adapter");
       break;
     case 5:
       cputs("MCGA - Multi-Color Graphics Array");
       break;
     case 6:
       cputs("VGA - Video Graphics Array");
       break;
     case 7:
       cputs("XGA - Extended Graphics Adapter");
       break;
     default:
       cputs("Unknown Video Card");
   }

   if(card > 3) {                        // check for EGA or higher
     gotoxy(42,7);
     if(getCRT())
       cputs("Monochrome");
     else
       cputs("Color");
   }

   if(card >= 6) {                       // check for VGA
     if(getVESA(&major,&minor,&vram)) {  // check for VESA support
       textattr(CHECK);                    
       gotoxy(42,10);
       cputs("yes");
       textattr(INFO);                    
       gotoxy(42,11);
       cprintf("%d.%d",major,minor);     // display VESA version
       if(major >= 1 && minor > 0) {     // check for VESA 1.1 or higher
         gotoxy(42,12);
         cprintf("%dK",vram);            // display Video RAM
       }  
     }
     else {
       textattr(CHECK);                    
       gotoxy(42,10);
       cputs("no");
       textattr(INFO);                    
     }
   }
   else {
     textattr(CHECK);                      
     gotoxy(42,10);
     cputs("no");
     textattr(INFO);                      
   }

   if(chkSB()) {                         // check for SoundBlaster
     gotoxy(24,15);
     cputs("SoundBlaster or compatible installed");
   }

   getch();                              // wait for keystroke
   textattr(CLEAR);                        
   clrscr();                             // clear screen

   /**********************************************************************\
   *                    Display DOS Information Screen                    *
   \**********************************************************************/ 

   textattr(LABELS);
   clrscr();   
   gotoxy(33,2);cputs("DOS and Windows");
   gotoxy(4,4);cputs("Reported DOS Version :");
   gotoxy(4,5);cputs("True DOS Version     :");
   gotoxy(4,6);cputs("DOS OEM Number       :");
   gotoxy(4,7);cputs("DOS Loaded           :");
   gotoxy(4,9);cputs("OS/2 Installed       :");
   gotoxy(4,10);cputs("OS/2 Version         :");
   gotoxy(4,12);cputs("Windows Resident     :");
   gotoxy(4,13);cputs("Windows Version      :");
   gotoxy(4,14);cputs("Windows Mode         :");
   gotoxy(50,3);cputs("ANSI.SYS installed     :");
   gotoxy(50,4);cputs("APPEND.EXE installed   :");
   gotoxy(50,5);cputs("ASSIGN.COM installed   :");
   gotoxy(50,6);cputs("DISPLAY.SYS installed  :");
   gotoxy(50,7);cputs("DOSKEY.COM installed   :");
   gotoxy(50,8);cputs("DRIVER.SYS installed   :");
   gotoxy(50,9);cputs("EGA.SYS installed      :");
   gotoxy(50,10);cputs("GRAFTABL.COM installed :");
   gotoxy(50,11);cputs("GRAPHICS.COM installed :");
   gotoxy(50,12);cputs("KEYB.COM installed     :");
   gotoxy(50,13);cputs("NLSFUNC.EXE installed  :");
   gotoxy(50,14);cputs("PRINT.COM installed    :");
   gotoxy(50,15);cputs("SHARE.EXE installed    :");
   gotoxy(50,16);cputs("SHELLB.COM installed   :");
   gotoxy(50,17);cputs("XMS2EMS.SYS installed  :");

   textattr(INFO);                        

   getDosV(&major,&minor);               // get DOS version
   oem=getDosOem();                      // get DOS OEM number
   drdos=getDrDosV();                    // get DR-DOS type

   gotoxy(27,4);
   cprintf("%d.%02d",major,minor);       // display DOS version

   gotoxy(27,5);
   if(!drdos) {
     if(!getTrueDosV(&major,&minor,&rev)){ // display true DOS version
       if(major==6 && !minor && !oem)      // check for IBM DOS 6.1
         minor=10;
       cprintf("%d.%02d Revision %c",major,minor,rev+65); 
     }
     else {
       cprintf("%d.%02d",major,minor);
     }
     textattr(CHECK);                        
     gotoxy(27,9);
     if(major>=10) {                     // check for OS/2
       cputs("yes");
       textattr(INFO);
       gotoxy(27,10);
       if(major==10)
         cputs("OS/2 v1.x");
       else if(major==20 && minor==30)
         cputs("OS/2 Warp v3.0");
       else if(major==20 && minor==10)
         cputs("OS/2 v2.1");
       else 
         cputs("OS/2 v2.x");
     }
     else {
       cputs("no");
       textattr(INFO);
     }
   }
   else {
     switch (drdos) {
       case 0x01:
         cputs("(Multi-User DR-DOS)");
         break;
       case 0x60:
         cputs("(DOS Plus)");
         break;
       case 0x63:
         cputs("(DR-DOS 3.41)");
         break;
       case 0x64:
         cputs("(DR-DOS 3.42)");
         break;
       case 0x65:
         cputs("(DR-DOS 5.0)");
         break;
       case 0x67:
         cputs("(DR-DOS 6.0)");
         break;
       case 0x70:
         cputs("(PalmDOS)");
         break;
       case 0x71:
         cputs("(DR-DOS 6.0)");
         break;
       case 0x72:
         cputs("(Novell DOS 7.0)");
     }
   }

   gotoxy(27,6);
   cprintf("%02Xh",oem);                 // display OEM number
   if(!drdos) {
     gotoxy(32,6);
     switch (oem) {
       case 0x00:
         cputs("(PC-DOS)");
         break;
       case 0x01:
         cputs("(Compaq DOS)");
         break;
       case 0x04:
         cputs("(AT&T DOS)");
         break;
       case 0x05:
         cputs("(Zenith DOS)");
         break;
       case 0x06:
         cputs("(HP DOS)");
         break;
       case 0x07:
         cputs("(Zenith DOS)");                
         break;
       case 0x0D:
         cputs("(Packard-Bell)");
         break;
       case 0x16:
         cputs("(DEC DOS)");
         break;
       case 0x23:
         cputs("(Olivetti DOS)");
         break;
       case 0x28:
         cputs("(TI DOS)");
         break;
       case 0x29:
         cputs("(Toshiba DOS)");
         break;
       case 0x4D:
         cputs("(HP DOS)");
         break;
       case 0xFF:
         cputs("(MS-DOS)");
     }
   }

   textattr(CHECK);                        
   gotoxy(27,7);
   if(major > 4 || drdos > 0x65) {       // check for DOS 5.0+ or DR-DOS 6.0+
     if(chkDosHigh())                    // see if DOS is loaded in high memory
       cputs("High");
     else
       cputs("Low");
   }
   else
     cputs("Low");

   gotoxy(27,12);
   if(getWinV(&major,&minor,&mode)) {    // check for Windows
     cputs("yes");
     textattr(INFO);                      
     gotoxy(27,13); 
     cprintf("%d.%02d",major,minor);     // display Windows version
     if(major==4)                        // check for Windows95
       cputs(" (Windows95)");
     gotoxy(27,14);
     if(mode)                            // display Windows mode
       cputs("Enhanced");
     else
       cputs("Standard");
     textattr(CHECK);                      
   }
   else 
     cputs("no"); 
 
   gotoxy(75,3);
   if(chkAnsi())                         // check for ANSI.SYS
     cputs("yes");
   else
     cputs("no");
   gotoxy(75,4);
   if(chkAppend())                       // check for APPEND.EXE
     cputs("yes");
   else
     cputs("no");
   gotoxy(75,5);
   if(chkAssign())                       // check for ASSIGN.COM
     cputs("yes");
   else
     cputs("no");
   gotoxy(75,6);
   if(chkDisplay())                      // check for DISPLAY.SYS
     cputs("yes");
   else
     cputs("no");
   gotoxy(75,7);
   if(chkDoskey())                       // check for DOSKEY.COM
     cputs("yes");
   else
     cputs("no");
   gotoxy(75,8);
   if(chkDriver())                       // check for DRIVER.SYS
     cputs("yes");                       
   else
     cputs("no");
   gotoxy(75,9);
   if(chkEGA())                          // check for EGA.SYS
     cputs("yes");
   else
     cputs("no");
   gotoxy(75,10);
   if(chkGraftabl())                     // check for GRAFTBL.COM
     cputs("yes");
   else
     cputs("no");
   gotoxy(75,11);
   if(chkGraphics())                     // check for GRAPHICS.COM
     cputs("yes");
   else 
     cputs("no");
   gotoxy(75,12);
   if(chkKeyb())                         // check for KEYB.COM
     cputs("yes");
   else
     cputs("no");
   gotoxy(75,13);
   if(chkNlsfunc())                      // check for NLSFUNC.EXE
     cputs("yes");
   else
     cputs("no");
   gotoxy(75,14);
   if(chkPrint())                        // check for PRINT.COM
     cputs("yes");
   else
     cputs("no");
   gotoxy(75,15);
   if(chkShare())                        // check for SHARE.EXE
     cputs("yes");
   else
     cputs("no");
   gotoxy(75,16);
   if(chkShellb())                       // check for SHELLB.COM
     cputs("yes");
   else
     cputs("no");
   gotoxy(75,17);
   if(chkXMA2EMS())                      // check for XMA2EMS.SYS
     cputs("yes");
   else
     cputs("no");

   textattr(INFO);                        

   getch();                              // wait for keystroke
   textattr(CLEAR);                        
   clrscr();                             // clear screen

   /**********************************************************************\
   *                   Display Mouse Information Screen                   *
   \**********************************************************************/ 

   textattr(LABELS);
   clrscr();   
   gotoxy(39,2);cputs("Mouse");
   gotoxy(25,6);cputs("Mouse Installed   :");
   gotoxy(25,7);cputs("Mouse Type        :");
   gotoxy(25,8);cputs("Driver Version    :");
   gotoxy(25,9);cputs("Number of Buttons :");
   gotoxy(25,10);cputs("Mouse IRQ         :");

   textattr(INFO);                        

   buttons=chkMouse();                   // check for mouse and get buttons

   if(buttons) {
     textattr(CHECK);                      
     gotoxy(45,6);
     cputs("yes");
     textattr(INFO);                      
     gotoxy(45,7);
     getMouseI(&type,&irq);              // get mouse information
     switch (type) {                     // display mouse type
       case 1:
         cputs("Bus Mouse");
         break;
       case 2:
         cputs("Serial Mouse");
         break;
       case 3:
         cputs("Inport Mouse");
         break;
       case 4:
         cputs("PS/2 Mouse");
         break;
       case 5:
         cputs("Hewlett-Packard Mouse");
         break;
     }
     getMouseV(&major,&minor);           // get mouse driver version
     gotoxy(45,8);
     cprintf("%d.%02d",major,minor);     // display mouse driver version
     gotoxy(45,9);
     cprintf("%d",buttons);              // display number of buttons
     gotoxy(45,10);
     if(type==4)                         // display mouse IRQ
       cputs("PS/2 Port");
     else
       cprintf("%d",irq);
   }
   else {
     textattr(CHECK);                      
     gotoxy(45,6);
     cputs("no");
     textattr(INFO);                      
   }

   getch();                              // wait for keystroke
   textattr(CLEAR);                        
   clrscr();                             // clear screen

   /**********************************************************************\
   *                  Display Shell Information Screen                    *
   \**********************************************************************/ 

   textattr(LABELS);
   clrscr();    
   gotoxy(28,2);cputs("TSR's, Drivers and Shells");
   gotoxy(4,5);cputs("DESQview Resident  :");
   gotoxy(4,6);cputs("DESQview Version   :");
   gotoxy(4,8);cputs("DOS Shell Resident :");
   gotoxy(4,9);cputs("CPTask Resident    :");
   gotoxy(4,10);cputs("Taskmax Resident   :");
   gotoxy(48,4);cputs("SMARTDrive Installed   :");
   gotoxy(48,5);cputs("PC-Cache Installed     :");
   gotoxy(48,6);cputs("PC-Kwik Installed      :");
   gotoxy(48,7);cputs("Ncache Installed       :");
   gotoxy(48,8);cputs("Hyperdisk Installed    :");
   gotoxy(48,10);cputs("DoubleSpace Installed  :");
   gotoxy(48,11);cputs("SpaceManager Installed :");
   gotoxy(48,12);cputs("Stacker Installed      :");
   gotoxy(48,14);cputs("MSCDEX Installed       :");
   gotoxy(48,15);cputs("MSCDEX Version         :");

   textattr(CHECK);                        

   gotoxy(25,5);
   if(getDESQv(&major,&minor)) {         // check for DESQview
     cputs("yes");
     textattr(INFO);                      
     gotoxy(25,6);
     cprintf("%d.%02d",major,minor);     // display DESQview version
     textattr(CHECK);                      
   }
   else 
     cputs("no"); 

   gotoxy(25,8);
   if(DosShell())                        // check for Microsoft DOS Shell
     cputs("yes");
   else
     cputs("no");

   gotoxy(25,9);
   if(CPTask())                          // check for PCTools CPTask
     cputs("yes");
   else
     cputs("no");

   gotoxy(25,10);
   if(TaskMax())                         // check for DR-DOS TaskMax
     cputs("yes");
   else
     cputs("no");

   gotoxy(73,4);
   if(SmartDrv())                        // check for Microsoft SmartDrv
     cputs("yes");
   else
     cputs("no");

   gotoxy(73,5);
   if(PcCache())                         // check for PCTools PC-Cache
     cputs("yes");
   else
     cputs("no");

   gotoxy(73,6);
   if(PcKwik())                          // check for PC-Kwik
     cputs("yes");
   else
     cputs("no");

   gotoxy(73,7);
   if(Ncache())                          // check for Norton Ncache
     cputs("yes");
   else
     cputs("no");

   gotoxy(73,8);
   if(HyperDisk())                       // check for HyperDisk 
     cputs("yes");
   else
     cputs("no");

   dblspace=DblSpace();                  // check for DoubleSpace
   gotoxy(73,10);                       
   if(dblspace)                         
     cputs("yes");
   else
     cputs("no");

   gotoxy(73,11);
   if(Spaceman())                        // check for Spacemanager
     cputs("yes");
   else
     cputs("no");

   stacker=Stacker();                    // check for Stacker
   gotoxy(73,12);
   if(stacker)
     cputs("yes");                      
   else
     cputs("no");

   mscdex=MSCDEX(&major,&minor);         // check for CD-ROM extension
   gotoxy(73,14);
   if(mscdex) {                         
     cputs("yes");
     textattr(INFO);                      
     gotoxy(73,15);
     cprintf("%d.%02d",major,minor);     // display MSCDEX version
   }
   else
     cputs("no");

   getch();                              // wait for keystroke
   textattr(CLEAR);                        
   clrscr();                             // clear screen

   /**********************************************************************\
   *                  Display Drives Information Screen                   *
   \**********************************************************************/ 
   
   textattr(LABELS);      
   clrscr();   
   gotoxy(38,2);cputs("Drives");
   gotoxy(3,3);cputs("Drive     Type                                     Free Space    Total Space");
   gotoxy(3,4);cputs("           ");

   textattr(INFO);                        

   x=5;
   y=5;

   gotoxy(x,y);
   cputs("                          ");

   if(!getFlopType(&a,&b)) {             // get floppy drive type
     gotoxy(x,y);
     switch (a) {
       case 0:
         break;                 
       case 1:
         cputs("A:");
         gotoxy(x+8,y);
         cputs("Floppy Drive, 5 360K DD");
         y++;
         break;
       case 2:
         cputs("A:");
         gotoxy(x+8,y);
         cputs("Floppy Drive, 5 1.2M HD");
         y++;
         break;
       case 3:
         cputs("A:");
         gotoxy(x+8,y);
         cputs("Floppy Drive, 3 720K DD");
         y++;
         break;
       case 4:
         cputs("A:");
         gotoxy(x+8,y);
         cputs("Floppy Drive, 3 1.44M HD");
         y++;
         break;
       case 5:
         cputs("A:");
         gotoxy(x+8,y);
         cputs("Floppy Drive, 3 2.88M ED");
         y++;
         break;
       default:
         cputs("A:");
         gotoxy(x+8,y);
         cputs("Unknown Floppy Drive Type");
         y++;
     }
     gotoxy(x,y);
     switch (b) {
       case 0:
         break;
       case 1:
         cputs("B:");
         gotoxy(x+8,y);
         cputs("Floppy Drive, 5 360K DD");
         y++;
         break;
       case 2:
         cputs("B:");
         gotoxy(x+8,y);
         cputs("Floppy Drive, 5 1.2M HD");
         y++;
         break;
       case 3:
         cputs("B:");
         gotoxy(x+8,y);
         cputs("Floppy Drive, 3 720K DD");
         y++;
         break;
       case 4:
         cputs("B:");
         gotoxy(x+8,y);
         cputs("Floppy Drive, 3 1.44M HD");
         y++;
         break;
       case 5:
         cputs("B:");
         gotoxy(x+8,y);
         cputs("Floppy Drive, 3 2.88M ED");
         y++;
         break;
       default:
         cputs("B:");
         gotoxy(x+8,y);
         cputs("Unknown Floppy Drive Type");
         y++;
     }
   }

   num = 3;                                      // starting drive
   lastdrive = getAvailDrvs();                   // get lastdrive

drvinfo:
   
   while (num<=lastdrive && num<=26 && y<=16) {     
     code = num + 64;
     sprintf(drive,"%c",code);
     if(isCDROM(drive)) {                        // check for CD-ROM drive
       gotoxy(x,y);
       cprintf("%c:",code);
       gotoxy(x+8,y);
       cputs("CD-ROM Drive");
       y++;
       num++;
       continue;
       }
     if(dblspace) {                              // check for DblSpace drive
       if(isDblSpace(drive)) {
         gotoxy(x,y);
         cprintf("%c:",code);
         gotoxy(x+8,y);
         cputs("DoubleSpace Drive");
         if(!getDrvSpace(drive,&SecPerClus,&FreeClus,&BytesPerSec,&TotalClus)) {
           ClusSize=BytesPerSec * SecPerClus;          // calc. cluster size
           FreeSpace=(FreeClus * ClusSize) / 1024000;  // calc. available space
           TotalSpace=TotalClus * ClusSize / 1024000;  // calc. total space
           gotoxy(x+51,y);
           cprintf("%5ldM",FreeSpace);             // display available space
           gotoxy(x+66,y);
           cprintf("%5ldM",TotalSpace);            // display total space
         }
         y++;
         num++;
         continue;
       }
     }
     if(stacker) {                               // check for Stacker drive
       if(isStacker(drive)) {
         gotoxy(x,y);
         cprintf("%c:",code);
         gotoxy(x+8,y);
         cputs("Stacker Drive");
         if(!getDrvSpace(drive,&SecPerClus,&FreeClus,&BytesPerSec,&TotalClus)) {
           ClusSize=BytesPerSec * SecPerClus;          // calc. cluster size
           FreeSpace=(FreeClus * ClusSize) / 1024000;  // calc. available space
           TotalSpace=TotalClus * ClusSize / 1024000;  // calc. total space
           gotoxy(x+51,y);
           cprintf("%5ldM",FreeSpace);             // display available space
           gotoxy(x+66,y);
           cprintf("%5ldM",TotalSpace);            // display total space
         }  
         y++;
         num++;
         continue;
       }
     }
     if(!chkRemovable(drive,&removable)) {       // check for fixed disk
       if(removable) {
         gotoxy(x,y);
         cprintf("%c:",code);
         gotoxy(x+8,y);
         cputs("Fixed Disk");
         if(!getDrvSpace(drive,&SecPerClus,&FreeClus,&BytesPerSec,&TotalClus)) {
           ClusSize=BytesPerSec * SecPerClus;          // calc. cluster size
           FreeSpace=(FreeClus * ClusSize) / 1024000;  // calc. available space
           TotalSpace=TotalClus * ClusSize / 1024000;  // calc. total space
           gotoxy(x+51,y);
           cprintf("%5ldM",FreeSpace);             // display available space
           gotoxy(x+66,y);
           cprintf("%5ldM",TotalSpace);            // display total space
         }
         if(!getDrvInfo(drive,&cyl,&heads,&sectors)) { // get fixed disk info
           y++;
           gotoxy(x+10,y);
           cprintf("%d Heads, %d Cylinders, %d Sec/Track",heads,cyl,sectors);
         }
         y++;
         num++;
         continue;
       }
     else
       gotoxy(x,y);
       cprintf("%c:",code);
       gotoxy(x+8,y);
       cputs("Removable");
       y++;
       num++;
       continue;
     }
     if(!chkRemote(drive,&remote)) {             // check for network drive
       if(remote) {
         gotoxy(x,y);
         cprintf("%c:",code);
         gotoxy(x+8,y);
         cputs("Remote Drive");
         if(!getDrvSpace(drive,&SecPerClus,&FreeClus,&BytesPerSec,&TotalClus)) {
           ClusSize=BytesPerSec * SecPerClus;          // calc. cluster size
           FreeSpace=(FreeClus * ClusSize) / 1024000;  // calc. available space
           TotalSpace=TotalClus * ClusSize / 1024000;  // calc. total space
           gotoxy(x+51,y);
           cprintf("%5ldM",FreeSpace);             // display available space
           gotoxy(x+66,y);
           cprintf("%5ldM",TotalSpace);            // display total space
         }
         y++;
       }
     }
     num++;
   }
   
   getch();                                 // wait for keystroke

   if(num<=lastdrive && num<=26) {          // see if a second page is needed
     y = 5;                                 // reset y-axis
     textattr(LABELS);      
     clrscr();   
     gotoxy(38,2);cputs("Drives");
     gotoxy(3,3);cputs("Drive     Type                                     Free Space    Total Space");
     gotoxy(3,4);cputs("           ");
     textattr(INFO);                          
     goto drvinfo;                          // display remaining drive info
   }

   textattr(CLEAR);                        
   clrscr();                             // clear screen

   /**********************************************************************\
   *                  Display Network Information Screen                  *
   \**********************************************************************/ 

   textattr(LABELS);
   clrscr();   
   gotoxy(38,2);cputs("Network");
   gotoxy(4,4);cputs("IPX Installed      :");
   gotoxy(4,6);cputs("Netbios Installed  :");
   gotoxy(4,8);cputs("Shell Installed    :");
   gotoxy(4,9);cputs("Shell Version      :");
   gotoxy(4,10);cputs("Shell Located in   :");
   gotoxy(4,12);cputs("Server Name        :");
   gotoxy(4,13);cputs("Netware Version    :");
   gotoxy(4,15);cputs("User Name          :");
   gotoxy(4,16);cputs("Login Date & Time  :");
   gotoxy(41,4);cputs("Number of Connections Supported :");
   gotoxy(41,5);cputs("Number of Connections in Use    :");
   gotoxy(41,6);cputs("Peak Connections Used           :");
   gotoxy(41,7);cputs("Maximum Connected Volumes       :");

   textattr(CHECK);                        

   gotoxy(25,4);
   if(chkIPX())                          // check for IPX
     cputs("yes");
   else
     cputs("no");
  
   gotoxy(25,6);
   if(Netbios())                         // check for Netbios
     cputs("yes");
   else
     cputs("no");

   gotoxy(25,8);
   if(NetShell(&major,&minor,&rev,&type)) {   // check for NetShell
     cputs("yes");
     textattr(INFO);                            
     gotoxy(25,9);
     cprintf("%d.%02d.%02d",major,minor,rev); // display NetShell Version
     gotoxy(25,10);
     switch (type) {                          // display memory type
       case 0:
         cputs("Conventional Memory");
         break;
       case 1:
         cputs("Expanded Memory");
         break;
       case 2:
         cputs("Extended Memory");
     }
     server=getNetName(&version,&sub,&conn,&use,&vol,&peak); // get server info
     gotoxy(25,12);
     cputs(server);                      // display server name
     gotoxy(25,13);
     cprintf("%d.%02d",version,sub);     // display NetWare version
     gotoxy(75,4);
     cprintf("%d",conn);                 // display number of connections
     gotoxy(75,5);
     cprintf("%d",use);                  // display connections in use
     gotoxy(75,6);
     cprintf("%d",peak);                 // display peak connections used
     gotoxy(75,7);
     cprintf("%d",vol);                  // display number of volumes supported
     user=getUserName();                 // get user name
     gotoxy(25,15);
     cputs(user);                        // display user name
     if(!getLoginTime(&year,&month,&day,&hour,&min,&sec,&week)) {
       gotoxy(25,16);
       cprintf("%02d-%02d-%d at %02d:%02d:%02d",month,day,year,hour,min,sec);
     }
   }
   else 
     cputs("no");
   
   getch();                              // wait for keystroke

   /**********************************************************************\
   *                                Exit                                  *
   \**********************************************************************/ 

   window(1,1,80,25);                    // reset screen coordinates
   textattr(CLEAR);                        
   clrscr();                             // clear screen
   _setcursortype(_NORMALCURSOR);        // restore cursor
   exit(0);
}

